set linesize 200
/************************************************************************************#
#*                                                                                   #
#* Purpose: STATA program to create permanent .DTA data set                          #
#*          harmonzd_tus_cps_1992_through_2019_with_replicate_wgts_beta              #
#*          with the combined Harmonized TUS CPS data and replicate weights          #
#*                                                                                   #
#*                                                                                   #
#*************************************************************************************/

/*****************************************************************************************
 Set working directory
 Input and output files are saved here
*****************************************************************************************/

cd "\\westat.com\DFS\NCIDCCPS\DCCPS - Global\Scientific Projects\TUS-CPS\Statistician\ifc\STATA work\prg\3. Harmonized data"

//*****************************************************************************************
// Read replicate STATA files with 1992 to 2019 harmonized data and 1992 to 2019 replicate weights to create
// one harmonized data analysis file with data and replicate weights

use harmonzd_tus_cps_1992_through_2019_beta, clear

merge 1:1 SurYear SurMonth RecordID using harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta

describe

tabulate _merge

save harmonzd_tus_cps_1992_through_2019_with_replicate_wgts_beta, replace